IMAGEEXT=".tif"; //extension for images
BLUR=true;
FILLHOLES=true;
SIGMA=3; //This is the amount to blur your image to make the mask
SEGMENT=1; //This is the channel to use to make a mask. Put 0 to average channels 1+2
ERODE=2; //Set to number of times to erode mask after thresholding
BACKSUB=50; //Radius for background subtraction. put 0 for no background subtraction.
HARDSUBTRACT=0; // prob you shouldn't change this.
METHOD="Triangle";






//METHOD="Huang";
//METHOD="Triangle"; //This is the threshold method used to make the mask
if(roiManager("count")>0)
	clearRoi();
path=getDirectory("Select a folder to analyze ...");
setBatchMode(true);
Measure(path);

function Measure(path)
	{
	count=getImgCount(path);
	fl=getFileList(path);
	Table.create("PrePostData");
	imgdone=0;
	for(i=0; i<fl.length; i++)
		{
		//if(File.isDirectory(path+"\\"+fl[i]))
			//Measure(path+"\\"+fl[i]);
		if(endsWith(fl[i], IMAGEEXT)==true)
			{
			open(path+""+fl[i]);
			print(fl[i]);
			Table.set("File", imgdone, fl[i], "PrePostData");
			run("Select All");
			Stack.getDimensions(w,h,c,s,f);
			segment(fl[i]);
			
			selectWindow(fl[i]);
			run("Select All");
			if(BACKSUB>0)
				run("Subtract Background...", "rolling="+BACKSUB+" stack");
			
			selectWindow("cell");
			run("Analyze Particles...", "add stack");
			saveROIs(path, "mask "+fl[i]);
			selectImage(fl[i]);
			for(ch=1; ch<c+1; ch++)
				{
				Stack.setChannel(ch);
				totals=measurePre(fl[i], ch);  // 0 is for Pre measurements
				Table.set("PreArea", imgdone, totals[1], "PrePostData");
				Table.set("Ch-"+ch+"_Mean", imgdone, totals[0], "PrePostData");
				Table.set("Ch-"+ch+"_CoV", imgdone, totals[2], "PrePostData");
				}
			clearRoi();
			
			close("*");	
			imgdone+=1;
			}
		}
	
		Table.save(path+"\\Presynaptic-Intensity_CoV.csv");	
	}

function measurePre(img, ch)
	{
	nROI=roiManager("count");
	TotalArea=0;
	TotalID=0;
	WeightedCoV=0;
	selectWindow(img);
	
	//run("Median...", "radius=1");
	if(nROI==1)
		{
		roiManager("Select", 0);
		Stack.setChannel(ch);
		getStatistics(area, mean, min, max, std); //THIS IS THE PART WITH THE MEASUREMENT
		TotalArea=area;
		TotalID=area*mean;
		WeightedCoV=std/mean*area;
		
		//Insert PostMeasurement here
		}
		else
			{
			for(r=0; r<nROI; r++)
				{
				roiManager("Select", r);
				Stack.setChannel(ch);
				getStatistics(area, mean, min, max, std); //THIS IS THE PART WITH THE MEASUREMENT
				TotalArea+=area;
				TotalID+=area*mean;
				if(mean>0)
					WeightedCoV=WeightedCoV+std/mean*area;
				//print("r:"+r+"  WCoV:"+WeightedCoV+"  std:"+std);
				}
			}
			
	TotalMean=TotalID/TotalArea;
	TotalCoV=WeightedCoV/TotalArea;
	//print("totalCoV:"+TotalCoV);
	return newArray(TotalMean, TotalArea, TotalCoV);
	}

function getImgCount(path)
	{
	count=0;
	fl=getFileList(path);
	for(i=0; i<fl.length; i++)
		{
		if(endsWith(fl[i], IMAGEEXT)==true)
			count=count+1;
		}
	return count;
	}

function segment(imp)
	{
	if(SEGMENT==0)
		{
		run("Duplicate...", "title=mask duplicate channels=1-3"); //mask for whole cell
		run("Split Channels");
		imageCalculator("Add create 32-bit stack", "C1-mask", "C3-mask");
		rename("mask");
		}
		else run("Duplicate...", "title=mask duplicate channels="+SEGMENT); //mask for whole cell
	run("Subtract...", "value="+HARDSUBTRACT+" stack");
	run("Gaussian Blur...", "sigma="+SIGMA+" stack");
	setAutoThreshold(METHOD+" dark stack");
	run("Convert to Mask", "method="+METHOD+" background=Dark black");
	//run("3D Objects Counter", "threshold=128 slice=15 min.=500 max.=1000000000 surfaces");
	//run("Convert to Mask", "method=Yen background=Dark calculate black");
	//run("Erode", "stack");
	
	if(FILLHOLES==true)
		run("Fill Holes", "stack");
		
	for(n=0; n<ERODE; n++)
		run("Erode", "stack");
	rename("cell");
	}


function saveROIs(path, imp)
	{
	rois=newArray(roiManager("count"));
	for (n=0; n<rois.length; n++)
		{
		rois[n]=n;
		}
	roiManager("select", rois);
	roiManager("Save", path+"\\"+stripX(imp)+"ROIs.zip");
	}

function clearRoi()
	{
	while(roiManager("count")>0)
		{
		roiManager("Select", 0);
		roiManager("Delete");
		}
	}

function stripX(string)
	{
	// This is because Macro language doesn't have a general use name without extension
	return substring(string, 0, lastIndexOf(string, "."));
	}